<?php

//デバッグ用
define('DEBUG_MODE', 'on');	//on or off エラー表示するかどうか (初期値off)
define('CACHE_MODE', 'on');	//on or off キャッシュ有効化 (初期値on)(PEAR Cache_Liteがインストールされていなければ自動的に無効)

//リクエストパラメータ
$params = array(
	"Operation"		=> "ItemSearch",
	"SearchIndex"	=> "Electronics",
	'BrowseNode'	=> '15691411',
	'Manufacturer'	=> 'アイリスオーヤマ',
	"Keywords"		=> '60Hz',
	"ResponseGroup" => 'Medium, Offers,  BrowseNodes',
	'MerchantId'	=> 'Amazon',						//商品を出品しているマーチャントを指定(デフォルトAmazon)
	'Availability'	=> 'Available',						//在庫がある商品だけを返す
	'Condition'		=> 'All',
	'Sort'			=> 'salesrank',
//	"Validate"		=> 'True',							//デバッグモード
);

//クライアント固有パラメータ
$params += array(
	'AWSAccessKeyId'	=> '********************',					// アクセスキー (必須)
	'AssociateTag'		=> '**********',							// トラッキングID (必須)
);
define('SECRET_KEY', '****************************************');	// シークレットキー (必須)

//固定パラメータ
$params += array(
	'Service'			=> 'AWSECommerceService',					//サービス名 (固定)
);
//エンドポイント http://ecs.amazonaws.jp/onca/xml または https://aws.amazonaws.jp/onca/xml
define('END_POINT0', 'http://');
define('END_POINT1', 'ecs.amazonaws.jp');
define('END_POINT2', '/onca/xml');

// cache設定項目
$cacheOptions = array (
	'cacheDir'					=> 'cache/',// キャッシュが保存される場所 (ディレクトリが存在しないときは自動作成)
	'lifeTime'					=> 3600*24,	// 指定した秒数はキャッシュを使う、nullにすると無期限
	'automaticCleaningFactor'	=> '20'		//(1/nの確率で)キャッシュファイルの自動削除
);




require_once('ClassGetAmazonAPI.php');

$amazon_api = new GetAmazonAPI($params);
$response = $amazon_api->response;

print_r($response['Items']);

?>
